-- Afficher uniquement les bières dont le pourcentage d’alcool dépasse strictement 9 %
SELECT *
FROM Biere
WHERE pourcentage_alcool > 9;

-- Afficher les bières dont le nom commence par la lettre B
SELECT *
FROM Biere
WHERE nom LIKE 'B%';

-- Afficher les bières dont le type est IPA ou Lager
SELECT *
FROM Biere
WHERE type = 'IPA'
   OR type = 'Lager';

-- Afficher les bières dont la description contient le mot summer
SELECT *
FROM Biere
WHERE description LIKE '%summer%';

-- Afficher les bières ayant une contenance supérieure à 33 cl et un taux d’alcool strictement supérieur à 9 %
SELECT *
FROM Biere
WHERE contenance > 33
  AND pourcentage_alcool > 9;

-- Afficher les bières de type Stout ou Triple dont le taux d’alcool est strictement supérieur à 8 %
SELECT *
FROM Biere
WHERE (type = 'Stout' OR type = 'Triple')
  AND pourcentage_alcool > 8;

-- Afficher les bières dont le pourcentage d’alcool est compris entre 4 et 4.5 inclus
SELECT *
FROM Biere
WHERE pourcentage_alcool BETWEEN 4 AND 4.5;

-- Afficher les bières de type Plisner ou Saison dont le nom contient la lettre A
SELECT *
FROM Biere
WHERE (type = 'Plisner' OR type = 'Saison')
  AND nom LIKE '%A%';

-- Afficher les commandes, avec le nom du client et le nom de la bière correspondante, pour les commandes dont le montant total dépasse 490 euros
SELECT c.nom AS client, b.nom AS biere, co.montant_total
FROM Commande co
JOIN Client c ON c.id = co.id_client
JOIN Commande_Detail cd ON cd.id_commande = co.id
JOIN Biere b ON b.id = cd.id_biere
WHERE co.montant_total > 490;

-- Afficher les réservations, avec le nom du client et la date de visite, pour les réservations dont le montant payé dépasse 400 euros
SELECT c.nom AS client, v.date AS visite_date, r.montant_paye
FROM Reservation r
JOIN Client c ON c.id = r.id_client
JOIN Visite v ON v.id = r.id_visite
WHERE r.montant_paye > 400;

-- Afficher les factures, ainsi que le nom du client associé, pour les factures dont le montant total dépasse 490 euros
SELECT f.id AS facture, f.date_emission, f.montant_total, c.nom
FROM Facture f
JOIN Commande co ON co.id = f.id_commande
JOIN Client c ON c.id = co.id_client
WHERE f.montant_total > 490;

-- Afficher les quantités de stock, la date de production du brassin et le nom de la bière, uniquement pour les stocks dont la quantité disponible dépasse 800 unités
SELECT s.quantite_disponible, br.date_production, b.nom
FROM Stock s
JOIN Brassin br ON br.id = s.id_brassin
JOIN Biere b ON b.id = br.id_biere
WHERE s.quantite_disponible > 800;

-- Afficher les fournisseurs, les ingrédients qu’ils fournissent et les brassins dans lesquels ces ingrédients ont été utilisés, uniquement pour les brassins produits après le 1er mars 2025
SELECT f.nom AS fournisseur, i.nom AS ingredient, br.id AS brassin
FROM Fournisseur f
JOIN Fournisseur_Ingredient fi ON fi.id_fournisseur = f.id
JOIN Ingredient i ON i.id = fi.id_ingredient
JOIN Brassin_Ingredient bi ON bi.id_ingredient = i.id
JOIN Brassin br ON br.id = bi.id_brassin
WHERE br.date_production > '2025-03-01';

-- Afficher les clients et les bières qu’ils ont achetées dans des commandes dont le montant total dépasse 490 euros
SELECT c.nom AS client, b.nom AS biere
FROM Client c
JOIN Commande co ON co.id_client = c.id
JOIN Commande_Detail cd ON cd.id_commande = co.id
JOIN Biere b ON b.id = cd.id_biere
WHERE co.montant_total > 490;

-- Afficher les clients ayant réservé une visite programmée après le 1er juin 2025
SELECT c.nom, v.date AS visite_date
FROM Client c
JOIN Reservation r ON r.id_client = c.id
JOIN Visite v ON v.id = r.id_visite
WHERE v.date > '2025-06-01';

-- Afficher les bières, les brassins dans lesquels elles ont été produites et les ingrédients utilisés, uniquement pour les ingrédients dont le nom contient filtrée ou source
SELECT b.nom AS biere, br.id AS brassin, i.nom AS ingredient
FROM Biere b
JOIN Brassin br ON br.id_biere = b.id
JOIN Brassin_Ingredient bi ON bi.id_brassin = br.id
JOIN Ingredient i ON i.id = bi.id_ingredient
WHERE i.nom LIKE '%filtrée%'
    OR i.nom LIKE '%source%';

-- Afficher les clients, leurs commandes et les lignes de commande associées, uniquement pour les lignes où la quantité commandée dépasse 48 unités
SELECT c.nom AS client, co.id AS commande, cd.quantite, b.nom AS biere
FROM Client c
JOIN Commande co ON co.id_client = c.id
JOIN Commande_Detail cd ON cd.id_commande = co.id
JOIN Biere b ON b.id = cd.id_biere
WHERE cd.quantite > 48;

-- Afficher les factures et le nom du client associé, pour les commandes passées après le 1er mars 2025
SELECT f.id AS facture, f.date_emission, c.nom
FROM Facture f
JOIN Commande co ON co.id = f.id_commande
JOIN Client c ON c.id = co.id_client
WHERE co.date_commande > '2025-03-01';

-- Afficher les quantités de stock, les brassins associés et les ingrédients utilisés dans ces brassins, uniquement pour des stocks dépassant 900 unités
SELECT s.quantite_disponible, br.id AS brassin, i.nom AS ingredient
FROM Stock s
JOIN Brassin br ON br.id = s.id_brassin
JOIN Brassin_Ingredient bi ON bi.id_brassin = br.id
JOIN Ingredient i ON i.id = bi.id_ingredient
WHERE s.quantite_disponible > 900;

-- Afficher les réservations, les clients et les visites associées, uniquement pour les réservations où le nombre de participants dépasse 8
SELECT r.nombre_participants, c.nom, v.date
FROM Reservation r
JOIN Client c ON c.id = r.id_client
JOIN Visite v ON v.id = r.id_visite
WHERE r.nombre_participants > 8;

-- Afficher le nombre total de bières dont le taux d’alcool dépasse 8 %
SELECT COUNT(*) AS nb_bieres_fortes
FROM Biere
WHERE pourcentage_alcool > 8;

-- Afficher la contenance moyenne des bières de type IPA
SELECT AVG(contenance) AS contenance_moyenne_ipa
FROM Biere
WHERE type = 'IPA';

-- Afficher le prix maximum des visites proposées après 2025
SELECT MAX(prix) AS prix_max
FROM Visite
WHERE date > '2025-01-01';

-- Afficher le montant minimal des commandes supérieures à 300 euros
SELECT MIN(montant_total) AS plus_petite_commande
FROM Commande
WHERE montant_total > 300;

-- Afficher le volume total produit dans les brassins réalisés après 2025
SELECT SUM(volume_total) AS volume_total_2025
FROM Brassin
WHERE date_production > '2025-01-01';

-- Afficher le montant total cumulé des commandes passées par le client "Alice"
SELECT SUM(co.montant_total) AS total_commandes_alice
FROM Commande co
JOIN Client c ON c.id = co.id_client
WHERE c.nom = 'Alice';

-- Afficher la quantité totale de bières vendues dans les commandes de plus de 300 euros
SELECT SUM(cd.quantite) AS total_bieres_vendues
FROM Commande co
JOIN Commande_Detail cd ON cd.id_commande = co.id
WHERE co.montant_total > 300;

-- Afficher le volume total produit pour les bières de type IPA
SELECT SUM(br.volume_total) AS volume_total_ipa
FROM Brassin br
JOIN Biere b ON b.id = br.id_biere
WHERE b.type = 'IPA';

-- Afficher la quantité totale d’ingrédients utilisés dans les brassins produits après 2025
SELECT SUM(bi.quantite) AS total_ingredients
FROM Brassin_Ingredient bi
JOIN Brassin br ON br.id = bi.id_brassin
WHERE br.date_production > '2025-01-01';

-- Afficher le montant total payé par les clients ayant réservé une visite après juin 2025
SELECT SUM(r.montant_paye) AS total_paye
FROM Reservation r
JOIN Visite v ON v.id = r.id_visite
WHERE v.date > '2025-06-01';

-- Afficher les clients pour lesquels il existe au moins une commande passée après le 01/03/2025
SELECT *
FROM Client c
WHERE EXISTS (
    SELECT 1
    FROM Commande co
    WHERE co.id_client = c.id
      AND co.date_commande > '2025-03-01'
);

-- Afficher les bières pour lesquelles il existe un brassin produit après 2025 le 01/03/2025
SELECT *
FROM Biere b
WHERE EXISTS (
    SELECT 1
    FROM Brassin br
    WHERE br.id_biere = b.id
      AND br.date_production > '2025-03-01'
);


-- Afficher les visites pour lesquelles il existe une réservation de plus de 7 participants
SELECT *
FROM Visite v
WHERE EXISTS (
    SELECT 1
    FROM Reservation r
    WHERE r.id_visite = v.id
      AND r.nombre_participants > 7
);

-- Afficher les commandes pour lesquelles il existe une ligne de commande avec quantité > 48
SELECT *
FROM Commande co
WHERE EXISTS (
    SELECT 1
    FROM Commande_Detail cd
    WHERE cd.id_commande = co.id
      AND cd.quantite > 48
);


-- Afficher les clients pour lesquels il n’existe aucune commande depuis 2024
SELECT *
FROM Client c
WHERE NOT EXISTS (
    SELECT 1
    FROM Commande co
    WHERE co.id_client = c.id
      AND co.date_commande > '2024-01-01'
);

-- Afficher les bières pour lesquelles il n’existe aucun brassin après 2024
SELECT *
FROM Biere b
WHERE NOT EXISTS (
    SELECT 1
    FROM Brassin br
    WHERE br.id_biere = b.id
      AND br.date_production > '2024-01-01'
);

-- Afficher les commandes pour lesquelles il n’existe aucune ligne de commande
SELECT *
FROM Commande co
WHERE NOT EXISTS (
    SELECT 1
    FROM Commande_Detail cd
    WHERE cd.id_commande = co.id
);

-- Afficher les clients pour lesquels il existe au moins une commande passée après le 1er mai 2025 contenant une ligne de commande avec une quantité > 40, et afficher chaque client une seule fois.
SELECT DISTINCT c.nom
FROM Client c
JOIN Commande co ON co.id_client = c.id
WHERE co.date_commande > '2025-03-01'
  AND EXISTS (
      SELECT 1
      FROM Commande_Detail cd
      WHERE cd.id_commande = co.id
        AND cd.quantite > 40
  );


-- Afficher les bières pour lesquelles il existe un brassin produit après 2025 utilisant au moins un ingrédient provenant d’un fournisseur, et pour lesquelles il n’existe aucune ligne de commande avec quantité > 40.
SELECT DISTINCT b.nom
FROM Biere b
JOIN Brassin br ON br.id_biere = b.id
WHERE br.date_production > '2025-01-01'
  AND EXISTS (
      SELECT 1
      FROM Brassin_Ingredient bi
      JOIN Fournisseur_Ingredient fi ON fi.id_ingredient = bi.id_ingredient
      WHERE bi.id_brassin = br.id
  )
  AND NOT EXISTS (
      SELECT 1
      FROM Commande_Detail cd
      WHERE cd.id_biere = b.id
        AND cd.quantite > 40
  );
